//******************************************
// file			: MQ6801_TCA.c
// version		: V1.1 2021/02/24
// brief		: initial,setup,operation
// note			:
//******************************************

#include "main.h"




//*********************************************************************
// name			: TCA0_Timer_Init
// brief		: set TCA0 to timer mode and set period to 1 ms
// note			:
//*********************************************************************
void TCA0_Timer_Init(void)
{
//====== enable function ======
    POFFCR0_TCA0EN = 1;                 // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    TA0MOD_TAM      = 0;                // set operation mode to timer mode
    
    TA0MOD_TADBE    = 1;                // enable double buffer
    TA0MOD_TACK     = 2;                // fcgck/4 = 1MHz = 1us
    TA0DRA          = 1000;             // set counter value to 1000 (1000 * 1us = 1ms)
}

//*********************************************************************
// name			: TCA0_PPG_Init
// brief		: set TCA0 to PPG mode, period to 1 ms and duty cycle to 50%
// note			:
//*********************************************************************
void TCA0_PPG_Init(void)
{
//====== pin configuration ======
    P7DR_P2         = 1;                // set P72 to output high (suggest output level as the same as the value of T0xMOD_TFF)
    P7CR_P2         = 1;                // set P72 as output pin

//====== enable function ======
    POFFCR0_TCA0EN  = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    TA0CR_TATFF     = 1;                // set initial state of function pin to high

    TA0MOD_TAM      = 3;                // set operation mode to PPG mode
    
    TA0MOD_TADBE    = 1;                // enable double buffer
    TA0MOD_TACK     = 2;                // fcgck/4 = 1MHz = 1us
    TA0DRA          = 1000;             // set PPG period to 1000 (1000 * 1us = 1ms)
    TA0DRB          = 500;              // set PPG duty cycle = 500/1000 = 50%

//	***set function pins after function initialization
    P7FC_P2         = 1;                // set P72 to special function pin (PPG)
}


//*********************************************************************
// name			: TCA0_ExtTrigTimer_Init
// brief		: set operation mode to external trigger timer mode, trigger level to L and counter value to 20000
// note			:
//*********************************************************************
void TCA0_ExtTrigTimer_Init(void)
{
//====== pin configuration ======    
    P7CR_P2         = 0;                // set P72 as input pin
    P7FC_P2         = 1;                // set P72 to special pin
    
//====== enable function ======
    POFFCR0_TCA0EN  = 1;                 // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    TA0MOD_TAM      = 4;                // set operation mode to external trigger timer mode
    TA0MOD_TADBE    = 1;                // enable double buffer
    TA0MOD_TAMETT   = 0;                // set external trigger timer mode control to trigger start
    TA0MOD_TATED    = 1;                // set external trigger input selection to falling edge/L level
    TA0MOD_TACK     = 2;                // fcgck/4 = 1MHz = 1us
    TA0DRA          = 20000;            // interrupt occurs every 20ms (20000 * 1 us = 20 ms)
}

//*********************************************************************
// name			: TCA0_Window_Init
// brief		: set operation mode to window mode, trigger level to L and counter value to 10000
//             counting upper limit time : 10000 * 1us = 10 ms                                        
// note			:
//*********************************************************************
void TCA0_Window_Init(void)
{
//====== pin configuration ======    
    P7CR_P2         = 0;                // set P72 as input pin
    P7FC_P2         = 1;                // set P72 to special pin
    
//====== enable function ======
    POFFCR0_TCA0EN  = 1;                 // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    TA0MOD_TAM      = 5;                // set operation mode to window mode
    TA0MOD_TADBE    = 1;                // enable double buffer    
    TA0MOD_TATED    = 1;                // set external trigger input selection to falling edge/L level
    TA0MOD_TACK     = 2;                // fcgck/4 = 1MHz = 1us
    TA0DRA          = 10000;            // set counter value to 10000
                                        // 10000 * 1 us = 10 ms
}           


//*********************************************************************
// name			: TCA0_PulseMeasure_Init  
// brief		: set the period of pulse width measurement to 0.5us
//            high pulse width upper limit = 65535 * 0.5us = 32767.5 us
//            period measurement upper limit = 65535 * 0.5us = 32767.5 us
// note			:
//*********************************************************************
void TCA0_PulseMeasure_Init(void)
{
//====== pin configuration ======    
    P7CR_P2         = 0;                // set P72 as input pin
    P7FC_P2         = 1;                // set P72 to special pin
    
//====== enable function ======
    POFFCR0_TCA0EN  = 1;                 // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    TA0MOD_TAM      = 6;                // set operation mode to pulse width measurement mode
    TA0MOD_TACK     = 3;                // fcgck/2 = 2MHz = 0.5us 
    TA0MOD_TAMCAP   = 0;                // double edge capture
    TA0MOD_TATED    = 0;                // set external trigger input selection to rising edge/H level
                                        
}      



//*********************************************************************
// name			: TCA0_SetDuty
// brief		: set duty cycle
// note			: 
//*********************************************************************
void set_TCA0_Duty(uint duty)
{
    TA0DRB          = duty;
}


//*********************************************************************
// name			: TCA0_SetPeriod
// brief		: set period
// note			: 
//*********************************************************************
void TCA0_SetPeriod(uint period)
{
    TA0DRA          = period;
}


//*********************************************************************
// name			: TCA0_Start
// brief		: start TCA0
// note			:
//*********************************************************************
void TCA0_Start(void)
{
    TA0CR_TAS       = 1;                
}


//*********************************************************************
// name			: TCA0_Stop
// brief		: stop TCA0
// note			:
//*********************************************************************
void TCA0_Stop(void)
{
    TA0CR_TAS       = 0;                
}


//*********************************************************************
// name			: TCA0_IntEnable
// brief		: enable TCA0 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TCA0_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTCA0      = 0;                // clear interrupt latch
    EI_INTTCA0      = 1;                // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: TCA0_IntDisable
// brief		: disble TCA0 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TCA0_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    
    EI_INTTCA0      = 0;                // clear interrupt enable flag
    IL_INTTCA0      = 0;                // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: TCA0_ReadSingleCapture
// brief		: read pulse width counter value
// note			: for pulse width measurement mode
//*********************************************************************
uint TCA0_ReadSingleCapture()
{
    return TA0DRB;
}



//*********************************************************************
// name			: TCA0_ReadDoubleCapture
// brief		: read period 
// note			: for pulse width measurement mode with double edge capture
//*********************************************************************
uint TCA0_ReadDoubleCapture()
{
    return TA0DRA;
}

//*********************************************************************
// name			: IntTCA0
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTCA0(void)
{
    P9DR_P0 = !P9DR_P0;					// reverse P90 output level
    NOP;                                // no operation
}




























