//******************************************
// file			: MQ6801_SFR.h
// version		: V1.2 2021/03/25
// brief		:
// note			: declare the detailed names represented by each bit of the special function registers
//******************************************

#ifndef	_MQ6801_SFR_NAME_H_
#define _MQ6801_SFR_NAME_H_

#include "MQ6801_SFR_addr.h"



//****************************************************
//******
#define NOP                     __asm("NOP")                        // no operation
//******
#define DI                      __asm("DI")                         // disable all maskable interrupts // EIRL_IMF=0
#define EI                      __asm("EI")                         // enable all maskable interrupts // EIRL_IMF=1
//******
#define CLR_WDT                 WDCDR_WDTCR2=0x4e                   // clear the watchdog timer
//******
#define DIS_WDT                 WDCTR_WDTEN=0; WDCDR_WDTCR2=0xb1    // disable the watchdog timer operation and clear the 8-bit up counter
//******
#define SET_P10_RESET_PIN    SYSCR3_RSTDIS=0; SYSCR4=0xb2        // set P10 to reset pin (default)
#define SET_P10_IO_PIN       SYSCR3_RSTDIS=1; SYSCR4=0xb2        // set P10 to GPIO pin
//******
//****************************************************



//====================================================
//			SFR1
//====================================================
//------------------------------------
#define P0DR                    _0x0000.byte
#define P0DR_P1                 _0x0000.bit.b1
#define P0DR_P0                 _0x0000.bit.b0

//------------------------------------
#define P1DR                    _0x0001.byte
#define P1DR_P0                 _0x0001.bit.b0

//------------------------------------
#define P4DR                    _0x0004.byte
#define P4DR_P7                 _0x0004.bit.b7
#define P4DR_P6                 _0x0004.bit.b6
#define P4DR_P5                 _0x0004.bit.b5
#define P4DR_P4                 _0x0004.bit.b4
#define P4DR_P3                 _0x0004.bit.b3
#define P4DR_P2                 _0x0004.bit.b2
#define P4DR_P1                 _0x0004.bit.b1
#define P4DR_P0                 _0x0004.bit.b0

//------------------------------------
#define P7DR                    _0x0007.byte
#define P7DR_P7                 _0x0007.bit.b7
#define P7DR_P6                 _0x0007.bit.b6
#define P7DR_P5                 _0x0007.bit.b5
#define P7DR_P4                 _0x0007.bit.b4
#define P7DR_P2                 _0x0007.bit.b2
#define P7DR_P1                 _0x0007.bit.b1
#define P7DR_P0                 _0x0007.bit.b0

//------------------------------------
#define P8DR                    _0x0008.byte
#define P8DR_P1                 _0x0008.bit.b1
#define P8DR_P0                 _0x0008.bit.b0

//------------------------------------
#define P9DR                    _0x0009.byte
#define P9DR_P1                 _0x0009.bit.b1
#define P9DR_P0                 _0x0009.bit.b0

//------------------------------------
#define P0PRD                   _0x000D.byte
#define P0PRD_P1                _0x000D.bit.b1
#define P0PRD_P0                _0x000D.bit.b0

//------------------------------------
#define P1PRD                   _0x000E.byte
#define P1PRD_P0                _0x000E.bit.b0

//------------------------------------
#define P4PRD                   _0x0011.byte
#define P4PRD_P7                _0x0011.bit.b7
#define P4PRD_P6                _0x0011.bit.b6
#define P4PRD_P5                _0x0011.bit.b5
#define P4PRD_P4                _0x0011.bit.b4
#define P4PRD_P3                _0x0011.bit.b3
#define P4PRD_P2                _0x0011.bit.b2
#define P4PRD_P1                _0x0011.bit.b1
#define P4PRD_P0                _0x0011.bit.b0

//------------------------------------


//------------------------------------
#define P7PRD                   _0x0014.byte
#define P7PRD_P7                _0x0014.bit.b7
#define P7PRD_P6                _0x0014.bit.b6
#define P7PRD_P5                _0x0014.bit.b5
#define P7PRD_P4                _0x0014.bit.b4

#define P7PRD_P2                _0x0014.bit.b2
#define P7PRD_P1                _0x0014.bit.b1
#define P7PRD_P0                _0x0014.bit.b0

//------------------------------------
#define P8PRD                   _0x0015.byte
#define P8PRD_P1                _0x0015.bit.b1
#define P8PRD_P0                _0x0015.bit.b0

//------------------------------------
#define P9PRD                   _0x0016.byte
#define P9PRD_P1                _0x0016.bit.b1
#define P9PRD_P0                _0x0016.bit.b0

//------------------------------------
#define T00REG                 _0x0026.byte
//------------------------------------
#define T01REG                 _0x0027.byte
//------------------------------------
#define T00PWM				   _0x0028.byte
#define T00PWM_PWMDUTY		   _0x0028.b7_1.b7_1
#define T00PWM_PWMAD		   _0x0028.bit.b0

#define T00PWM_PWMDUTYL        _0x0028.b7_4.b7_4
#define T00PWM_PWMAD3          _0x0028.bit.b3
#define T00PWM_PWMAD2          _0x0028.bit.b2  
#define T00PWM_PWMAD1          _0x0028.bit.b1
#define T00PWM_PWMAD0          _0x0028.bit.b0

//------------------------------------
#define T01PWM				   _0x0029.byte
#define T01PWM_PWMDUTY		   _0x0029.b7_1.b7_1
#define T01PWM_PWMAD		   _0x0029.bit.b0

#define T01PWM_PWMDUTH		   _0x0029.b3_0.b3_0
//------------------------------------
#define T00MOD                  _0x002A.byte
#define T00MOD_TFF              _0x002A.bit.b7
#define T00MOD_DBE              _0x002A.bit.b6
#define T00MOD_TCK              _0x002A.b5_3.b5_3
#define T00MOD_EIN              _0x002A.bit.b2
#define T00MOD_TCM              _0x002A.b1_0.b1_0

//------------------------------------
#define T01MOD                  _0x002B.byte
#define T01MOD_TFF              _0x002B.bit.b7
#define T01MOD_DBE              _0x002B.bit.b6
#define T01MOD_TCK              _0x002B.b5_3.b5_3
#define T01MOD_EIN              _0x002B.bit.b2
#define T01MOD_TCM              _0x002B.b1_0.b1_0

//------------------------------------
#define T001CR                  _0x002C.byte
#define T001CR_OUTAND           _0x002C.bit.b3
#define T001CR_TCAS             _0x002C.bit.b2
#define T001CR_T01RUN           _0x002C.bit.b1
#define T001CR_T00RUN           _0x002C.bit.b0

//------------------------------------
#define TA0DRA                  _0x002D.word
#define TA0DRAL                 _0x002D.byte[0]
#define TA0DRAH                 _0x002D.byte[1]

//------------------------------------
#define TA0DRB                  _0x002F.word
#define TA0DRBL                 _0x002F.byte[0]
#define TA0DRBH                 _0x002F.byte[1]

//------------------------------------
#define TA0MOD                  _0x0031.byte
#define TA0MOD_TADBE            _0x0031.bit.b7
#define TA0MOD_TATED            _0x0031.bit.b6
#define TA0MOD_TAMCAP           _0x0031.bit.b5
#define TA0MOD_TAMETT           _0x0031.bit.b5
#define TA0MOD_TACK             _0x0031.b4_3.b4_3
#define TA0MOD_TAM              _0x0031.b2_0.b2_0

//------------------------------------
#define TA0CR                   _0x0032.byte
#define TA0CR_TAOVE             _0x0032.bit.b7
#define TA0CR_TATFF             _0x0032.bit.b6
#define TA0CR_TANC              _0x0032.b5_4.b5_4
#define TA0CR_TAACAP            _0x0032.bit.b1
#define TA0CR_TAMPPG            _0x0032.bit.b1
#define TA0CR_TAS               _0x0032.bit.b0

//------------------------------------
#define TA0SR                   _0x0033.byte
#define TA0SR_TAOVF             _0x0033.bit.b7
#define TA0SR_TACPFA            _0x0033.bit.b1
#define TA0SR_TACPFB            _0x0033.bit.b0

//------------------------------------
#define ADCCR1                  _0x0034.byte
#define ADCCR1_ADRS             _0x0034.bit.b7
#define ADCCR1_AMD              _0x0034.b6_5.b6_5
#define ADCCR1_AINEN            _0x0034.bit.b4
#define ADCCR1_SAIN             _0x0034.b3_0.b3_0

//------------------------------------
#define ADCCR2                  _0x0035.byte
#define ADCCR2_EOCF             _0x0035.bit.b7
#define ADCCR2_ADBF             _0x0035.bit.b6
#define ADCCR2_ACK              _0x0035.b2_0.b2_0

//------------------------------------
#define ADCDR                   _0x0036.word
#define ADCDRL                  _0x0036.byte[0]
#define ADCDRH                  _0x0036.byte[1]

//------------------------------------
#define DVOCR                   _0x0038.byte
#define DVOCR_DVOEN             _0x0038.bit.b2
#define DVOCR_DVOCK             _0x0038.b1_0.b1_0

//------------------------------------
#define TBTCR                   _0x0039.byte
#define TBTCR_TBTEN             _0x0039.bit.b3
#define TBTCR_TBTCK             _0x0039.b2_0.b2_0

//------------------------------------
#define EIRL                    _0x003A.byte
//******
//#define EIRL_EF6                _0x003A.bit.b6
//#define EI_INTSIO0              _0x003A.bit.b6
//******
#define EIRL_EF5                _0x003A.bit.b5
#define EI_INTTBT               _0x003A.bit.b5
//******
#define EIRL_EF4                _0x003A.bit.b4
#define EI_INTWUC               _0x003A.bit.b4
//******
#define EIRL_IMF                _0x003A.bit.b0
#define EI_IMF                  _0x003A.bit.b0

//------------------------------------
#define EIRH                    _0x003B.byte
//******
//#define EIRH_EF15               _0x003B.bit.b7
//#define EI_INTSBI               _0x003B.bit.b7
//******
#define EIRH_EF14               _0x003B.bit.b6
#define EI_INTTCA0              _0x003B.bit.b6
//******
#define EIRH_EF13               _0x003B.bit.b5
#define EI_INTTC01              _0x003B.bit.b5
//******
#define EIRH_EF12               _0x003B.bit.b4
#define EI_INTTC00              _0x003B.bit.b4
//******
#define EIRH_EF11               _0x003B.bit.b3
#define EI_INTRTC               _0x003B.bit.b3
//******
#define EIRH_EF10               _0x003B.bit.b2
#define EI_INTADC               _0x003B.bit.b2
//******
#define EIRH_EF9                _0x003B.bit.b1
#define EI_INTLVD               _0x003B.bit.b1
//******
//------------------------------------
#define EIRE                    _0x003C.byte
//******
#define EIRE_EF23               _0x003C.bit.b7
#define EI_INTTXD1              _0x003C.bit.b7
//******
#define EIRE_EF22               _0x003C.bit.b6
#define EI_INTRXD1              _0x003C.bit.b6
//******
#define EIRE_EF20               _0x003C.bit.b4
#define EI_INT4                 _0x003C.bit.b4
//******
#define EIRE_EF19               _0x003C.bit.b3
#define EI_INT3                 _0x003C.bit.b3
//******
#define EIRE_EF18               _0x003C.bit.b2
#define EI_INT2                 _0x003C.bit.b2
//------------------------------------
#define EIRD                    _0x003D.byte
//******
//#define EIRD_EF29               _0x003D.bit.b5
//#define EI_INTTC05              _0x003D.bit.b5
//******
//#define EIRD_EF28               _0x003D.bit.b4
//#define EI_INTTC04              _0x003D.bit.b4
//******
#define EIRD_EF25               _0x003D.bit.b1
#define EI_INTTC03              _0x003D.bit.b1
//******
#define EIRD_EF24               _0x003D.bit.b0
#define EI_INTTC02              _0x003D.bit.b0

//------------------------------------
#define PSW                     _0x003F.byte
#define PSW_JF                  _0x003F.bit.b7
#define PSW_ZF                  _0x003F.bit.b6
#define PSW_CF                  _0x003F.bit.b5
#define PSW_HF                  _0x003F.bit.b4
#define PSW_SF                  _0x003F.bit.b3
#define PSW_VF                  _0x003F.bit.b2
//====================================================
//			SFR1
//====================================================



//====================================================
//			SFR3
//====================================================
//------------------------------------
#define UATCNG                  _0x0E57.byte
#define UATCNG_UAT1IO           _0x0E57.bit.b1

//------------------------------------
#define ADCVRF                  _0x0EE7.byte
#define ADCVRF_VRFSEL           _0x0EE7.b2_0.b2_0

//------------------------------------
#define FSCTRL                  _0x0EED.byte
//#define FSCTRL_FOSCCKS          _0x0EED.bit.b2_1
#define FSCTRL_PAD40SEL         _0x0EED.bit.b5
#define FSCTRL_PAD41SEL         _0x0EED.bit.b4
#define FSCTRL_PAD46SEL         _0x0EED.bit.b3
#define FSCTRL_PAD47SEL         _0x0EED.bit.b2
#define FSCTRL_FSSEL            _0x0EED.bit.b0
//====================================================
//			SFR3
//====================================================



//====================================================
//			SFR2
//====================================================
//------------------------------------
#define P0PD                    _0x0F00.byte
#define P0PD_P1                 _0x0F00.bit.b1
#define P0PD_P0                 _0x0F00.bit.b0

//------------------------------------
#define P1PD                    _0x0F01.byte
#define P1PD_P0                 _0x0F01.bit.b0

//------------------------------------
#define P4PD                    _0x0F04.byte
#define P4PD_P7                 _0x0F04.bit.b7

#define P4PD_P5                 _0x0F04.bit.b5
#define P4PD_P4                 _0x0F04.bit.b4
#define P4PD_P3                 _0x0F04.bit.b3
#define P4PD_P2                 _0x0F04.bit.b2
#define P4PD_P1                 _0x0F04.bit.b1
#define P4PD_P0                 _0x0F04.bit.b0

//------------------------------------
#define P7PD                    _0x0F07.byte
#define P7PD_P7                 _0x0F07.bit.b7
#define P7PD_P6                 _0x0F07.bit.b6
#define P7PD_P5                 _0x0F07.bit.b5

#define P7PD_P4                 _0x0F07.bit.b4
#define P7PD_P2                 _0x0F07.bit.b2
#define P7PD_P1                 _0x0F07.bit.b1
#define P7PD_P0                 _0x0F07.bit.b0

//------------------------------------
#define P8PD                    _0x0F08.byte
#define P8PD_P1                 _0x0F08.bit.b1
#define P8PD_P0                 _0x0F08.bit.b0

//------------------------------------
#define P9PD                    _0x0F09.byte
#define P9PD_P1                 _0x0F09.bit.b1
#define P9PD_P0                 _0x0F09.bit.b0

//------------------------------------
#define P0CR                    _0x0F1A.byte
#define P0CR_P1                 _0x0F1A.bit.b1
#define P0CR_P0                 _0x0F1A.bit.b0

//------------------------------------
#define P1CR                    _0x0F1B.byte
#define P1CR_P0                 _0x0F1B.bit.b0

//------------------------------------
#define P4CR                    _0x0F1E.byte
#define P4CR_P7                 _0x0F1E.bit.b7
#define P4CR_P6                 _0x0F1E.bit.b6
#define P4CR_P5                 _0x0F1E.bit.b5
#define P4CR_P4                 _0x0F1E.bit.b4
#define P4CR_P3                 _0x0F1E.bit.b3
#define P4CR_P2                 _0x0F1E.bit.b2
#define P4CR_P1                 _0x0F1E.bit.b1
#define P4CR_P0                 _0x0F1E.bit.b0

//------------------------------------
#define P7CR                    _0x0F21.byte
#define P7CR_P7                 _0x0F21.bit.b7
#define P7CR_P6                 _0x0F21.bit.b6
#define P7CR_P5                 _0x0F21.bit.b5
#define P7CR_P4                 _0x0F21.bit.b4
#define P7CR_P2                 _0x0F21.bit.b2
#define P7CR_P1                 _0x0F21.bit.b1
#define P7CR_P0                 _0x0F21.bit.b0

//------------------------------------
#define P8CR                    _0x0F22.byte
#define P8CR_P1                 _0x0F22.bit.b1
#define P8CR_P0                 _0x0F22.bit.b0

//------------------------------------
#define P9CR                    _0x0F23.byte
#define P9CR_P1                 _0x0F23.bit.b1
#define P9CR_P0                 _0x0F23.bit.b0

//------------------------------------
#define P0PU                    _0x0F27.byte
#define P0PU_P1                 _0x0F27.bit.b1
#define P0PU_P0                 _0x0F27.bit.b0

//------------------------------------
#define P1PU                    _0x0F28.byte
#define P1PU_P0                 _0x0F28.bit.b0

//------------------------------------
#define P4PU                    _0x0F2B.byte
#define P4PU_P5                 _0x0F2B.bit.b5
#define P4PU_P4                 _0x0F2B.bit.b4
#define P4PU_P3                 _0x0F2B.bit.b3
#define P4PU_P2                 _0x0F2B.bit.b2
#define P4PU_P1                 _0x0F2B.bit.b1
#define P4PU_P0                 _0x0F2B.bit.b0
//------------------------------------
#define P7PU                    _0x0F2E.byte
#define P7PU_P7                 _0x0F2E.bit.b7
#define P7PU_P6                 _0x0F2E.bit.b6
#define P7PU_P5                 _0x0F2E.bit.b5
#define P7PU_P2                 _0x0F2E.bit.b2
#define P7PU_P1                 _0x0F2E.bit.b1
#define P7PU_P0                 _0x0F2E.bit.b0

//------------------------------------
#define P8PU                    _0x0F2F.byte
#define P8PU_P1                 _0x0F2F.bit.b1
#define P8PU_P0                 _0x0F2F.bit.b0

//------------------------------------
#define P9PU                    _0x0F30.byte
#define P9PU_P1                 _0x0F30.bit.b1
#define P9PU_P0                 _0x0F30.bit.b0

//------------------------------------
#define P0FC                    _0x0F34.byte
#define P0FC_P0                 _0x0F34.bit.b0

//------------------------------------
#define P4FC                    _0x0F38.byte
#define P4FC_P7                 _0x0F38.bit.b7
#define P4FC_P6                 _0x0F38.bit.b6
#define P4FC_P5                 _0x0F38.bit.b5
#define P4FC_P4                 _0x0F38.bit.b4
#define P4FC_P3                 _0x0F38.bit.b3
#define P4FC_P2                 _0x0F38.bit.b2
#define P4FC_P1                 _0x0F38.bit.b1
#define P4FC_P0                 _0x0F38.bit.b0

//------------------------------------
#define P7FC                    _0x0F3B.byte
#define P7FC_P4                 _0x0F3B.bit.b4
#define P7FC_P2                 _0x0F3B.bit.b2
#define P7FC_P1                 _0x0F3B.bit.b1
#define P7FC_P0                 _0x0F3B.bit.b0

//------------------------------------
#define P8FC                    _0x0F3C.byte
#define P8FC_P1                 _0x0F3C.bit.b1
#define P8FC_P0                 _0x0F3C.bit.b0

//------------------------------------
#define P9FC                    _0x0F3D.byte
#define P9FC_P1                 _0x0F3D.bit.b1
#define P9FC_P0                 _0x0F3D.bit.b0


//------------------------------------
#define UART1CR1                _0x0F54.byte
#define UART1CR1_TXE            _0x0F54.bit.b7
#define UART1CR1_RXE            _0x0F54.bit.b6
#define UART1CR1_STOPBT         _0x0F54.bit.b5
#define UART1CR1_EVEN           _0x0F54.bit.b4
#define UART1CR1_PE             _0x0F54.bit.b3
#define UART1CR1_IRDASEL        _0x0F54.bit.b2
#define UART1CR1_BRG            _0x0F54.bit.b1

//------------------------------------
#define UART1CR2                _0x0F55.byte
#define UART1CR2_RTSEL          _0x0F55.b5_3.b5_3
#define UART1CR2_RXDNC          _0x0F55.b2_1.b2_1
#define UART1CR2_STOPBR         _0x0F55.bit.b0

//------------------------------------
#define UART1DR                 _0x0F56.byte

//------------------------------------
#define UART1SR                 _0x0F57.byte
#define UART1SR_PERR            _0x0F57.bit.b7
#define UART1SR_FERR            _0x0F57.bit.b6
#define UART1SR_OERR            _0x0F57.bit.b5
#define UART1SR_RBSY            _0x0F57.bit.b3
#define UART1SR_RBFL            _0x0F57.bit.b2
#define UART1SR_TBSY            _0x0F57.bit.b1
#define UART1SR_TBFL            _0x0F57.bit.b0

//------------------------------------
// TD1BUF and RD1BUF have the same address
#define TD1BUF                  _0x0F58.byte
#define RD1BUF                  _0x0F58.byte

//------------------------------------
#define POFFCR0                 _0x0F74.byte
#define POFFCR0_TC023EN         _0x0F74.bit.b5
#define POFFCR0_TC001EN         _0x0F74.bit.b4
#define POFFCR0_TCA0EN          _0x0F74.bit.b0

//------------------------------------
#define POFFCR1                 _0x0F75.byte
#define POFFCR1_UART1EN         _0x0F75.bit.b1

//------------------------------------
#define POFFCR2                 _0x0F76.byte
#define POFFCR2_RTCEN           _0x0F76.bit.b5


//------------------------------------
#define POFFCR3                 _0x0F77.byte
#define POFFCR3_INT4EN          _0x0F77.bit.b4
#define POFFCR3_INT3EN          _0x0F77.bit.b3
#define POFFCR3_INT2EN          _0x0F77.bit.b2

//------------------------------------
#define T02REG                  _0x0F88.byte
//------------------------------------
#define T03REG                  _0x0F89.byte
//------------------------------------
#define T02PWM                  _0x0F8A.byte
#define T02PWM_PWMDUTY	        _0x0F8A.b7_1.b7_1 
#define T02PWM_PWMAD	        _0x0F8A.bit.b0
                                        
#define T02PWM_PWMDUTYL         _0x0F8A.b7_4.b7_4
#define T02PWM_PWMAD3           _0x0F8A.bit.b3
#define T02PWM_PWMAD2           _0x0F8A.bit.b2  
#define T02PWM_PWMAD1           _0x0F8A.bit.b1
#define T02PWM_PWMAD0           _0x0F8A.bit.b0

//------------------------------------
#define T03PWM                  _0x0F8B.byte
#define T03PWM_PWMDUTY          _0x0F8B.b7_1.b7_1
#define T03PWM_PWMAD	        _0x0F8B.bit.b0
                                       
#define T03PWM_PWMDUTH          _0x0F8B.b3_0.b3_0
//------------------------------------
#define T02MOD                  _0x0F8C.byte
#define T02MOD_TFF              _0x0F8C.bit.b7
#define T02MOD_DBE              _0x0F8C.bit.b6
#define T02MOD_TCK              _0x0F8C.b5_3.b5_3
#define T02MOD_EIN              _0x0F8C.bit.b2
#define T02MOD_TCM              _0x0F8C.b1_0.b1_0

//------------------------------------
#define T03MOD                  _0x0F8D.byte
#define T03MOD_TFF              _0x0F8D.bit.b7
#define T03MOD_DBE              _0x0F8D.bit.b6
#define T03MOD_TCK              _0x0F8D.b5_3.b5_3
#define T03MOD_EIN              _0x0F8D.bit.b2
#define T03MOD_TCM              _0x0F8D.b1_0.b1_0

//------------------------------------
#define T023CR                  _0x0F8E.byte
#define T023CR_OUTAND           _0x0F8E.bit.b3
#define T023CR_TCAS             _0x0F8E.bit.b2
#define T023CR_T03RUN           _0x0F8E.bit.b1
#define T023CR_T02RUN           _0x0F8E.bit.b0

//------------------------------------
#define T00CNT                 _0x0F90.byte

//------------------------------------
#define T01CNT                 _0x0F91.byt

//------------------------------------
#define T02CNT                 _0x0F92.byte

//------------------------------------
#define T03CNT                 _0x0F93.byte

//------------------------------------

#define KWUCR0                  _0x0FC4.byte
#define KWUCR0_KW3LE            _0x0FC4.bit.b7
#define KWUCR0_KW3EN            _0x0FC4.bit.b6
#define KWUCR0_KW2LE            _0x0FC4.bit.b5
#define KWUCR0_KW2EN            _0x0FC4.bit.b4
#define KWUCR0_KW1LE            _0x0FC4.bit.b3
#define KWUCR0_KW1EN            _0x0FC4.bit.b2
#define KWUCR0_KW0LE            _0x0FC4.bit.b1
#define KWUCR0_KW0EN            _0x0FC4.bit.b0

//------------------------------------
#define KWUCR1                  _0x0FC5.byte
#define KWUCR1_KW7LE            _0x0FC5.bit.b7
#define KWUCR1_KW7EN            _0x0FC5.bit.b6
#define KWUCR1_KW6LE            _0x0FC5.bit.b5
#define KWUCR1_KW6EN            _0x0FC5.bit.b4
#define KWUCR1_KW5LE            _0x0FC5.bit.b3
#define KWUCR1_KW5EN            _0x0FC5.bit.b2
#define KWUCR1_KW4LE            _0x0FC5.bit.b1
#define KWUCR1_KW4EN            _0x0FC5.bit.b0

//------------------------------------
#define VDCR1                   _0x0FC6.byte
#define VDCR1_VD2F              _0x0FC6.bit.b7
#define VDCR1_VD2SF             _0x0FC6.bit.b6
#define VDCR1_VD2LVL            _0x0FC6.b5_4.b5_4
#define VDCR1_VD1F              _0x0FC6.bit.b3
#define VDCR1_VD1SF             _0x0FC6.bit.b2
#define VDCR1_VD1LVL            _0x0FC6.b1_0.b1_0

//------------------------------------
#define VDCR2                   _0x0FC7.byte
#define VDCR2_VD2MOD            _0x0FC7.bit.b3
#define VDCR2_VD2EN             _0x0FC7.bit.b2
#define VDCR2_VD1MOD            _0x0FC7.bit.b1
#define VDCR2_VD1EN             _0x0FC7.bit.b0

//------------------------------------
#define RTCCR                   _0x0FC8.byte
#define RTCCR_RTCSEL            _0x0FC8.b3_1.b3_1
#define RTCCR_RTCRUN            _0x0FC8.bit.b0

//------------------------------------
#define IRSTSR                  _0x0FCC.byte
#define IRSTSR_FCLR             _0x0FCC.bit.b7
#define IRSTSR_WDT2RF           _0x0FCC.bit.b7
#define IRSTSR_FLSRF            _0x0FCC.bit.b6
#define IRSTSR_LVD2RF           _0x0FCC.bit.b3
#define IRSTSR_LVD1RF           _0x0FCC.bit.b2
#define IRSTSR_SYSRF            _0x0FCC.bit.b1
#define IRSTSR_WDTRF            _0x0FCC.bit.b0

//------------------------------------
#define WUCCR                   _0x0FCD.byte
#define WUCCR_WUCRST            _0x0FCD.bit.b7
#define WUCCR_WUCDIV            _0x0FCD.b3_2.b3_2
#define WUCCR_WUCSEL            _0x0FCD.b1_0.b1_0

//------------------------------------
#define WUCDR                   _0x0FCE.byte

//------------------------------------
#define CGCR                    _0x0FCF.byte
#define CGCR_FCGCKSEL           _0x0FCF.b1_0.b1_0

//------------------------------------
#define FLSCR1                  _0x0FD0.byte
#define FLSCR1_FLSMD            _0x0FD0.b7_5.b7_5

//------------------------------------
// FLSCR2 and FLSCRM have the same address
#define FLSCR2                  _0x0FD1.byte
#define FLSCR2_CR1EN            _0x0FD1.byte
#define FLSCRM                  _0x0FD1.byte
#define FLSCRM_FLSMDM           _0x0FD1.bit.b5

//------------------------------------
#define FLSSTB                  _0x0FD2.byte
#define FLSSTB_FSTB             _0x0FD2.bit.b0

//------------------------------------
#define WDCTR                   _0x0FD4.byte
#define WDCTR_WDTEN             _0x0FD4.bit.b5
#define WDCTR_WDTW              _0x0FD4.b4_3.b4_3
#define WDCTR_WDTT              _0x0FD4.b2_1.b2_1
#define WDCTR_WDTOUT            _0x0FD4.bit.b0

//------------------------------------
#define WDCDR                   _0x0FD5.byte
#define WDCDR_WDTCR2            _0x0FD5.byte

//------------------------------------
#define WDCNT                   _0x0FD6.byte

//------------------------------------
#define WDST                    _0x0FD7.byte
#define WDST_WINTST2            _0x0FD7.bit.b2
#define WDST_WINTST1            _0x0FD7.bit.b1
#define WDST_WDTST              _0x0FD7.bit.b0

//------------------------------------
#define EINTCR2                 _0x0FD9.byte
#define EINTCR2_INTLVL          _0x0FD9.bit.b4
#define EINTCR2_INTES           _0x0FD9.b3_2.b3_2
#define EINTCR2_INTNC           _0x0FD9.b1_0.b1_0

//------------------------------------
#define EINTCR3                 _0x0FDA.byte
#define EINTCR3_INTLVL          _0x0FDA.bit.b4
#define EINTCR3_INTES           _0x0FDA.b3_2.b3_2
#define EINTCR3_INTNC           _0x0FDA.b1_0.b1_0

//------------------------------------
#define EINTCR4                 _0x0FDB.byte
#define EINTCR4_INTLVL          _0x0FDB.bit.b4
#define EINTCR4_INTES           _0x0FDB.b3_2.b3_2
#define EINTCR4_INTNC           _0x0FDB.b1_0.b1_0

//------------------------------------
#define SYSCR1                  _0x0FDC.byte
#define SYSCR1_STOP             _0x0FDC.bit.b7
#define SYSCR1_RELM             _0x0FDC.bit.b6
#define SYSCR1_OUTEN            _0x0FDC.bit.b5
#define SYSCR1_DV9CK            _0x0FDC.bit.b4
#define SYSCR1_OSCSEL           _0x0FDC.bit.b3

//------------------------------------
#define SYSCR2                  _0x0FDD.byte
#define SYSCR2_OSCEN            _0x0FDD.bit.b7
#define SYSCR2_XEN              _0x0FDD.bit.b6
#define SYSCR2_XTEN             _0x0FDD.bit.b5
#define SYSCR2_SYSCK            _0x0FDD.bit.b4
#define SYSCR2_IDLE             _0x0FDD.bit.b3
#define SYSCR2_TGHALT           _0x0FDD.bit.b2

//------------------------------------
#define SYSCR3                  _0x0FDE.byte
#define SYSCR3_RSTDIS           _0x0FDE.bit.b0

//------------------------------------
// SYSCR4 and SYSSR4 have the same address
#define SYSCR4                  _0x0FDF.byte
#define SYSSR4                  _0x0FDF.byte
#define SYSSR4_RSTDISS          _0x0FDF.bit.b0

//------------------------------------
#define ILL                     _0x0FE0.byte
//******
//#define ILL_IL6                 _0x0FE0.bit.b6
//#define IL_INTSIO0              _0x0FE0.bit.b6
//******
#define ILL_IL5                 _0x0FE0.bit.b5
#define IL_INTTBT               _0x0FE0.bit.b5
//******
#define ILL_IL4                 _0x0FE0.bit.b4
#define IL_INTWUC               _0x0FE0.bit.b4
//******
#define ILL_IL3                 _0x0FE0.bit.b3
#define IL_INTWDT               _0x0FE0.bit.b3

//------------------------------------
#define ILH                     _0x0FE1.byte
//******
//#define ILH_IL15                _0x0FE1.bit.b7
//#define IL_INTSBI               _0x0FE1.bit.b7
//******
#define ILH_IL14                _0x0FE1.bit.b6
#define IL_INTTCA0              _0x0FE1.bit.b6
//******
#define ILH_IL13                _0x0FE1.bit.b5
#define IL_INTTC01              _0x0FE1.bit.b5
//******
#define ILH_IL12                _0x0FE1.bit.b4
#define IL_INTTC00              _0x0FE1.bit.b4
//******
#define ILH_IL11                _0x0FE1.bit.b3
#define IL_INTRTC               _0x0FE1.bit.b3
//******
#define ILH_IL10                _0x0FE1.bit.b2
#define IL_INTADC               _0x0FE1.bit.b2
//******
#define ILH_IL9                 _0x0FE1.bit.b1
#define IL_INTLVD               _0x0FE1.bit.b1

//------------------------------------
#define ILE                     _0x0FE2.byte
//******
#define ILE_IL23                _0x0FE2.bit.b7
#define IL_INTTXD1              _0x0FE2.bit.b7
//******
#define ILE_IL22                _0x0FE2.bit.b6
#define IL_INTRXD1              _0x0FE2.bit.b6
//******
#define ILE_IL20                _0x0FE2.bit.b4
#define IL_INT4                 _0x0FE2.bit.b4
//******
#define ILE_IL19                _0x0FE2.bit.b3
#define IL_INT3                 _0x0FE2.bit.b3
//******
#define ILE_IL18                _0x0FE2.bit.b2
#define IL_INT2                 _0x0FE2.bit.b2

//------------------------------------
#define ILD                     _0x0FE3.byte
//******
//#define ILD_IL29                _0x0FE3.bit.b5
//#define IL_INTTC05              _0x0FE3.bit.b5
//******
//#define ILD_IL28                _0x0FE3.bit.b4
//#define IL_INTTC04              _0x0FE3.bit.b4
//******
#define ILD_IL25                _0x0FE3.bit.b1
#define IL_INTTC03              _0x0FE3.bit.b1
//******
#define ILD_IL24                _0x0FE3.bit.b0
#define IL_INTTC02              _0x0FE3.bit.b0

//====================================================
//			SFR2
//====================================================



#endif		//_MQ6801_SFR_NAME_H_















